/* 
 * Copyright (C) 2006-2021 Registro.br. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 1. Redistribution of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY REGISTRO.BR ``AS IS AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIE OF FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL REGISTRO.BR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
/* $Id$ */
/** @file  LaunchCheckCmd.H
 *  @brief EPP LaunchCheckCmd Class
 */

#ifndef __LAUNCH_CHECK_CMD_H__
#define __LAUNCH_CHECK_CMD_H__

#include <string>

#include "Launch.H"

using std::string;

LIBEPP_NICBR_NS_BEGIN

/// EPP LaunchCheckCmd Class
class LaunchCheckCmd
{
public:
	/// EPP LaunchCheckCmd::Type Class
	class Type
	{
	public:
		/// Possible type values
		enum Value {
			NONE,
			CLAIMS,
			AVAIL
		};

		/// Convert type to text format
		/**
		 * @param value type value
		 * @return text representation of the type
		 */
		static string toStr(const Value value)
		{
			switch (value) {
			case NONE:
				break;
			case CLAIMS:
				return "claims";
			case AVAIL:
				return "avail";
			}

			return "";
		}

		/// Convert text type to value
		/**
		 * @param value text type
		 * @return value representation of the type
		 */
		static Value fromStr(const string &value)
		{
			if (value == "claims") {
				return CLAIMS;

			} else if (value == "avail") {
				return AVAIL;
			}

			return NONE;
		}
	};

	// Default constructor
	LaunchCheckCmd()
	{
		reset();
	}

	/// Sets the expected type of object
	/**
	 * @param type expected type of object
	 */
	void set_type(const Type::Value type) { _type = type; }

	/// Returns the expected type of object
	/**
	 * @return expected type of object
	 */
	Type::Value get_type() const { return _type; }

	/// Sets the phase of the launch
	/**
	 * @param phase phase of the launch
	 */
	void set_phase(const LaunchPhase &phase) { _phase = phase; }

	/// Returns the phase of the launch
	/**
	 * @return phase of the launch
	 */
	LaunchPhase get_phase() const { return _phase; }

	/// Reset object attributes
	void reset()
	{
		_type = Type::NONE;
		_phase.reset();
	}

private:
	/// Expected type of object
	Type::Value _type;

	/// Phase of the launch
	LaunchPhase _phase;
};

LIBEPP_NICBR_NS_END

#endif // __LAUNCH_CHECK_CMD_H__
