/* 
 * Copyright (C) 2006-2021 Registro.br. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 1. Redistribution of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY REGISTRO.BR ``AS IS AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIE OF FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL REGISTRO.BR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
/* $Id$ */
/** @file DomainCheckRsp.H
 *  @brief EPP DomainCheckRsp Class
 */

#ifndef __DOMAIN_CHECK_RSP_H__
#define __DOMAIN_CHECK_RSP_H__

#include <string>
#include <map>

#include "libepp_nicbr.H"

#include "Response.H"
#include "LaunchCheckRsp.H"

using std::string;
using std::map;
using std::less;

LIBEPP_NICBR_NS_BEGIN

/// EPP DomainCheckRsp Class
class DomainCheckRsp : public Response
{
public:

	struct Availability {
		string available;
		string reason;
	};

	/// Default constructor
	DomainCheckRsp(bool reset = true) : Response(false)
	{
		if (reset) {
			this->reset();
		}
	}

	/// Inserts availability information for a domain name to the list
	/**
	   @param domain      domain name
	   @param available   domain availability ["0" | "1"]
	   @param reason      reason of unavailability
	*/
	void insert_availability(const string &domain,
	                         const string &available,
	                         const string &reason);
  
	/// Returns the domain's availability list
	/**
	   @return domain availability list
	*/
	map< string, Availability, less<string> > get_availability_list() const;

	/// Sets the launch result set
	/**
	 * @param launch launch result set
	 */
	void set_launch(const LaunchCheckRsp &launch)
	{
		_launch = launch;
	}

	/// Returns the launch result set
	/**
	 * @return launch result set
	 */
	LaunchCheckRsp get_launch() const { return _launch; }

	/// Resets object attributes
	void reset() 
	{
		Response::reset();
		_availability_list.clear();
		_launch.reset();
	}

protected:
	/// Domain response list
	map< string, Availability, less<string> > _availability_list;

	/// Launch result set
	LaunchCheckRsp _launch;
};

LIBEPP_NICBR_NS_END
#endif //__DOMAIN_CHECK_RSP_H__
