/* 
 * Copyright (C) 2006-2021 Registro.br. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 1. Redistribution of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY REGISTRO.BR ``AS IS AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIE OF FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL REGISTRO.BR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
/* $Id$ */
/** @file DefRegTransferCmd.H
 *  @brief EPP DefRegTransferCmd Class
 */

#ifndef __DEF_REG_TRANSFER_RSP_H__
#define __DEF_REG_TRANSFER_RSP_H__

#include <list>
#include <string>

#include "libepp_nicbr.H"

#include "Response.H"
#include "CommonData.H"

using std::list;
using std::string;

LIBEPP_NICBR_NS_BEGIN

/// EPP DefRegTransferRsp Class
class DefRegTransferRsp : public Response
{
public:
	/// Default constructor
	DefRegTransferRsp(bool reset = true) : Response(false)
	{
		if (reset) {
			this->reset();
		}
	}

	/// Sets repository object identification
	/**
	   @param roid   repository object identification
	*/
	void set_roid(const string &roid) { _roid = roid; }

	/// Returns repository object identification
	/**
	   @return repository object identification
	*/
	string get_roid() const { return _roid; }

	/// Sets the state of the most recent transfer request
	/**
	 * @param status state of the most recent transfer request
	 */
	void set_trStatus(const string &status) { _trStatus = status; }

	/// Returns the state of the most recent transfer request
	/**
	 * @return state of the most recent transfer request
	 */
	string get_trStatus() const { return _trStatus; }

	/// Sets the identifier of the client that requested the object
	/// transfer
	/**
	 * @param id identifier of the client that requested the object
	 * transfer
	 */
	void set_reID(const string &id) { _reID = id; }

	/// Returns the identifier of the client that requested the object
	/// transfer
	/**
	 * @return identifier of the client that requested the object
	 * transfer
	 */
	string get_reID() const { return _reID; }

	/// Sets date and time that the transfer was requested
	/**
	 * @param date date and time that the transfer was requested
	 */
	void set_reDate(const string &date) { _reDate = date; }

	/// Returns date and time that the transfer was requested
	/**
	 * @return date and time that the transfer was requested
	 */
	string get_reDate() const { return _reDate; }

	/// Sets identifier of the client that SHOULD act upon the transfer
	/// request
	/**
	 * @param id identifier of the client that SHOULD act upon the
	 * transfer request
	 */
	void set_acID(const string &id) { _acID = id; }

	/// Returns identifier of the client that SHOULD act upon the
	/// transfer request
	/**
	 * @return identifier of the client that SHOULD act upon the
	 * transfer request
	 */
	string get_acID() const { return _acID; }

	/// Sets date and time of a required or completed response
	/**
	 * @param date date and time of a required or completed response
	 */
	void set_acDate(const string &date) { _acDate = date; }

	/// Returns date and time of a required or completed response
	/**
	 * @return date and time of a required or completed response
	 */
	string get_acDate() const { return _acDate; }

	/// Sets end of the Defensive Registration object's validity period
	/// if the <transfer> command caused or causes a change in the
	/// validity period
	/**
	 * @param date end of the Defensive Registration object's validity
	 * period
	 */
	void set_exDate(const string &date) { _exDate = date; }

	/// Returns end of the Defensive Registration object's validity
	/// period if the <transfer> command caused or causes a change in
	/// the validity period
	/**
	 * @return end of the Defensive Registration object's validity
	 * period
	 */
	string get_exDate() const { return _exDate; }

	/// Resets object attributes
	void reset() 
	{
		Response::reset();
		_roid.clear();
		_trStatus.clear();
		_reID.clear();
		_reDate.clear();
		_acID.clear();
		_acDate.clear();
		_exDate.clear();
	}

protected:
	/// Repository Object Identifier assigned to the Defensive
	/// Registration object when the object was created
	string _roid;

	/// State of the most recent transfer request
	string _trStatus;

	/// Identifier of the client that requested the object transfer
	string _reID;

	/// Date and time that the transfer was requested
	string _reDate;

	/// Identifier of the client that SHOULD act upon the transfer
	/// request
	string _acID;

	/// Date and time of a required or completed response
	string _acDate;

	/// End of the Defensive Registration object's validity period if
	/// the <transfer> command caused or causes a change in the validity
	/// period
	string _exDate;
};

LIBEPP_NICBR_NS_END

#endif // __DEF_REG_TRANSFER_RSP_H__
