/* 
 * Copyright (C) 2006-2021 Registro.br. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 1. Redistribution of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY REGISTRO.BR ``AS IS AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIE OF FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL REGISTRO.BR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
/* $Id$ */
/** @file AsnReserveCreateCmd.H
 *  @brief EPP AsnReserveCreateCmd Class
 */

#ifndef __ASNRESERVECREATECMD_H__
#define __ASNRESERVECREATECMD_H__

#include <map>
#include <string>
#include <vector>

#include "libepp_nicbr.H"

#include "Command.H"

using std::map;
using std::string;
using std::vector;

LIBEPP_NICBR_NS_BEGIN

/// EPP AsnReserveCreate Class
class AsnReserveCreateCmd : public Command
{
public:
	/// Default constructor
	AsnReserveCreateCmd(bool reset = true) : Command(false)
	{
		if (reset) {
			this->reset();
		}
	}

	/// Sets start of the asn range
	/**
	   @param asn   autonomous system number
	*/
	void set_start_asn(const int asn)
	{
		_start_asn = asn;
	}

	/// Returns start of the asn range
	/**
	   @return autonomous system number
	*/
	int get_start_asn() const
	{
		return _start_asn;
	}

	/// Sets start of the asn range
	/**
	   @param asn   autonomous system number
	*/
	void set_end_asn(const int asn)
	{
		_end_asn = asn;
	}

	/// Returns end of the asn range
	/**
	   @return autonomous system number
	*/
	int get_end_asn() const
	{
		return _end_asn;
	}

	/// Sets organization
	/**
	   @param organization   organization to be associated with the reservation
	*/
	void set_organization(const string &organization)
	{
		_organization = organization;
	}

	/// Returns organization associated with the reservation
	/**
	   @return organization owner of the reservation
	*/
	string get_organization() const
	{
		return _organization;
	}

	/// Sets comment
	/**
	   @param comment   comment to be associated with the asn
	*/
	void set_comment(const string &comment)
	{
		_comment = comment;
	}

	/// Returns comment about reservation
	/**
	   @return comment comment about the reservation
	*/
	string get_comment() const
	{
		return _comment;
	}

	void reset()
	{
		Command::reset();
		_start_asn = 0;
		_end_asn = 0;
		_organization = "";
		_comment = "";
	}

protected:
	/// start of the asn range
	int _start_asn;

	/// end of the asn range
	int _end_asn;

	/// organization associated with the reservation
	string _organization;

	/// comment about the reservation
	string _comment;
};

LIBEPP_NICBR_NS_END
#endif // __ASNRESERVECREATECMD_H__
